<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Register a Gym</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600&display=swap');
        * {margin:0;padding:0;box-sizing:border-box;font-family:'Poppins',sans-serif;}
        body {
            background-color: transparent;
            display: flex;justify-content: center;align-items: center;
            min-height: 100vh;padding: 20px;
        }
        .form-container {
            background: white;padding: 40px 30px;border-radius: 20px;
            box-shadow: 0 6px 20px rgba(0,0,0,0.1);width: 100%;max-width: 800px;
            margin: 20px auto;
        }
        .form-container h2 {text-align:center;color:#5C3F17;margin-bottom:25px;}
        .form-container h3 {color:#D30402;margin:20px 0 10px;font-size:18px;border-bottom:2px solid #FBFBFB;padding-bottom:5px;}
        .info-message {
            background: #f8f9fa;
            border-left: 4px solid #D30402;
            padding: 15px;
            margin-bottom: 25px;
            border-radius: 8px;
            font-size: 14px;
            color: #5C3F17;
        }
        form {display:grid;grid-template-columns:repeat(2, 1fr);gap:20px;}
        .form-group {display:flex;flex-direction:column;}
        .form-group.full-width {grid-column:span 2;}
        label {margin-bottom:6px;font-weight:500;color:#5C3F17;}
        label.required:after {content:" *";color:#D30402;}
        input, textarea, select {padding:12px;border:1px solid #8C8570;border-radius:8px;background:#FBFBFB;font-size:14px;outline:none;transition:all 0.3s;}
        input:focus, textarea:focus, select:focus {border-color:#D30402;box-shadow:0 0 0 2px rgba(211,4,2,0.1);background:white;}
        .file-upload {position:relative;border:2px dashed #8C8570;padding:25px;text-align:center;cursor:pointer;border-radius:10px;background-color:#FBFBFB;transition:all 0.3s;}
        .file-upload:hover {border-color:#D30402;background-color:#fff5f5;transform:translateY(-2px);}
        .file-upload input {position:absolute;top:0;left:0;width:100%;height:100%;opacity:0;cursor:pointer;}
        .file-upload span {display:block;color:#8C8570;font-size:14px;}
        .file-upload .upload-icon {font-size:40px;color:#D30402;margin-bottom:10px;}
        .preview-grid {display:grid;grid-template-columns:repeat(3, 1fr);gap:15px;margin-top:15px;}
        .preview-container {position:relative;}
        .preview-container img {width:100%;height:120px;object-fit:cover;border-radius:8px;border:2px solid #eee;}
        .remove-btn {position:absolute;top:5px;right:5px;background:#D30402;color:white;border:none;border-radius:50%;width:24px;height:24px;cursor:pointer;font-size:12px;display:flex;align-items:center;justify-content:center;}
        .char-count {text-align:right;font-size:12px;color:#8C8570;margin-top:5px;}
        .char-count.warning {color:#D30402;}
        button {grid-column:span 2;padding:14px;border:none;border-radius:8px;background:#D30402;color:white;font-weight:600;font-size:16px;cursor:pointer;transition:all 0.3s;margin-top:20px;}
        button:hover {background:#b90302;transform:translateY(-2px);}
        button:disabled {background:#ccc;cursor:not-allowed;transform:none;}
        .form-note {grid-column:span 2;font-size:12px;color:#8C8570;text-align:center;margin-top:15px;font-style:italic;}
        .error {color:#D30402;font-size:12px;margin-top:5px;}
        .validation-process {background:#e7f4e4;border:1px solid #28a745;padding:15px;border-radius:8px;margin-top:20px;text-align:center;}
        @media(max-width:768px){
            form{grid-template-columns:1fr;}
            .form-group.full-width {grid-column:1;}
            button {grid-column:1;}
            .preview-grid {grid-template-columns:1fr;}
            .form-container {padding:20px 15px;}
        }
    </style>
</head>
<body>
<div class="form-container">
    <h2>🎯 Register Your Gym</h2>

    <div class="info-message">
        <strong>💡 Important Information:</strong> Your gym will be submitted for validation by our team before being published on the site. You will receive a notification once it's approved.
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    @if(session('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Congratulations!',
                html: '{{ session('success') }}<br><br><small>You can add another gym if needed.</small>',
                confirmButtonColor: '#D30402',
                confirmButtonText: 'OK'
            });
        </script>
    @endif

    @if($errors->any())
        <script>
            Swal.fire({
                icon: 'error',
                title: 'Validation Error',
                html: '<ul style="text-align:left">@foreach($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>',
                confirmButtonColor: '#D30402'
            });
        </script>
    @endif

    <form action="{{ route('gyms.store') }}" method="POST" enctype="multipart/form-data" id="gymForm">
        @csrf

        <h3>📸 Gym Photos</h3>

        <!-- Photo 1 -->
        <div class="form-group">
            <label class="required">Main Photo</label>
            <div class="file-upload">
                <div class="upload-icon">📁</div>
                <span>Click or drag an image here</span>
                <input type="file" name="photo1" accept="image/*" id="photo1" />
            </div>
            @error('photo1')
            <span class="error">{{ $message }}</span>
            @enderror
        </div>

        <!-- Photo 2 -->
        <div class="form-group">
            <label>Additional Photo</label>
            <div class="file-upload">
                <div class="upload-icon">📁</div>
                <span>Click or drag an image here</span>
                <input type="file" name="photo2" accept="image/*" id="photo2" />
            </div>
        </div>

        <!-- Photo 3 -->
        <div class="form-group">
            <label>Additional Photo</label>
            <div class="file-upload">
                <div class="upload-icon">📁</div>
                <span>Click or drag an image here</span>
                <input type="file" name="photo3" accept="image/*" id="photo3" />
            </div>
        </div>

        <div class="form-group full-width">
            <div class="preview-grid" id="previewGrid"></div>
        </div>

        <h3>🏋️ Gym Information</h3>

        <div class="form-group">
            <label for="informations" class="required">Gym Name</label>
            <input type="text" name="informations" id="informations" value="{{ old('informations') }}" required />
            @error('informations')
            <span class="error">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="specialite">Specialty</label>
            <input type="text" name="specialite" id="specialite" value="{{ old('specialite') }}" placeholder="Ex: Fitness, Martial Arts, CrossFit" />
        </div>

        <div class="form-group">
            <label for="nationalite" class="required">Nationality</label>
            <input type="text" name="nationalite" id="nationalite" value="{{ old('nationalite') }}" required />
            @error('nationalite')
            <span class="error">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="adresse" class="required">Address</label>
            <input type="text" name="adresse" id="adresse" value="{{ old('adresse') }}" required />
            @error('adresse')
            <span class="error">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="tel" class="required">Phone</label>
            <input type="text" name="tel" id="tel" value="{{ old('tel') }}" required />
            @error('tel')
            <span class="error">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="email">Email</label>
            <input type="email" name="email" id="email" value="{{ old('email') }}" placeholder="example@mail.com" />
            @error('email')
            <span class="error">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="website">Website</label>
            <input type="url" name="website" id="website" value="{{ old('website') }}" placeholder="https://www.yoursite.com" />
            @error('website')
            <span class="error">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group full-width">
            <label for="description" class="required">Description</label>
            <textarea name="description" id="description" maxlength="400" rows="4" required>{{ old('description') }}</textarea>
            <div class="char-count" id="charCount">0 / 400 characters</div>
            @error('description')
            <span class="error">{{ $message }}</span>
            @enderror
        </div>

        <button type="submit" id="submitBtn">✅ Register My Gym</button>

        <div class="form-note">
            <p>⚠️ All fields marked with * are required</p>
            <p>📞 Our team may contact you for validation</p>
        </div>
    </form>

    @if(session('success'))
        <div class="validation-process">
            <h4>🎉 Request Submitted!</h4>
            <p>Your gym is now pending validation.</p>
            <p>Estimated processing time: 24-48 hours</p>
            <p><a href="{{ route('gyms.create') }}" style="color:#D30402;font-weight:bold;">↻ Add Another Gym</a></p>
        </div>
    @endif
</div>

<script>
    // Image preview
    const photoInputs = ['photo1', 'photo2', 'photo3'];
    const previews = {};

    photoInputs.forEach(photoId => {
        const input = document.getElementById(photoId);
        if (input) {
            input.addEventListener('change', function(e) {
                previewImage(e.target, photoId);
            });
        }
    });

    function previewImage(input, photoId) {
        const previewGrid = document.getElementById('previewGrid');
        const file = input.files[0];

        if (!file) return;

        // Create container for this preview
        const previewContainer = document.createElement('div');
        previewContainer.className = 'preview-container';
        previewContainer.id = 'preview-' + photoId;

        // Read image
        const reader = new FileReader();
        reader.onload = function(e) {
            previewContainer.innerHTML = `
                <img src="${e.target.result}" alt="Preview">
                <button type="button" class="remove-btn" onclick="removeImage('${photoId}')">×</button>
            `;

            // Add to grid if it doesn't exist already
            const existingPreview = document.getElementById('preview-' + photoId);
            if (!existingPreview) {
                previewGrid.appendChild(previewContainer);
            }
        };
        reader.readAsDataURL(file);
    }

    function removeImage(photoId) {
        const input = document.getElementById(photoId);
        const preview = document.getElementById('preview-' + photoId);

        if (input) input.value = '';
        if (preview) preview.remove();
    }

    // Character counter for description
    const description = document.getElementById('description');
    const charCount = document.getElementById('charCount');

    if (description) {
        description.addEventListener('input', function() {
            const length = this.value.length;
            charCount.textContent = length + ' / 400 characters';
            charCount.className = length > 380 ? 'char-count warning' : 'char-count';
        });

        // Initialize counter
        description.dispatchEvent(new Event('input'));
    }

    // Form validation before submission
    document.getElementById('gymForm').addEventListener('submit', function(e) {
        const requiredFields = ['informations', 'adresse', 'tel', 'nationalite', 'description'];
        let isValid = true;
        let errorMessage = '';

        // Check required fields
        requiredFields.forEach(fieldId => {
            const field = document.getElementById(fieldId);
            if (field && !field.value.trim()) {
                isValid = false;
                errorMessage += `The field "${field.previousElementSibling?.textContent || fieldId}" is required.\n`;
                field.style.borderColor = '#D30402';
            } else if (field) {
                field.style.borderColor = '';
            }
        });

        // Check at least one photo
        const hasPhoto = photoInputs.some(id => document.getElementById(id).files.length > 0);
        if (!hasPhoto) {
            isValid = false;
            errorMessage += "Please add at least one photo of your gym.\n";
        }

        if (!isValid) {
            e.preventDefault();
            Swal.fire({
                icon: 'warning',
                title: 'Missing Fields',
                text: errorMessage,
                confirmButtonColor: '#D30402'
            });
        } else {
            // Disable button to prevent double-click
            const submitBtn = document.getElementById('submitBtn');
            submitBtn.disabled = true;
            submitBtn.innerHTML = '⏳ Processing...';
        }
    });

    // Height adjustment for iframe
    function sendHeight() {
        const height = document.documentElement.scrollHeight;
        window.parent.postMessage({ type: 'resize', height: height }, '*');
    }

    window.addEventListener('load', sendHeight);
    window.addEventListener('resize', sendHeight);
    window.addEventListener('input', sendHeight);

    const observer = new MutationObserver(sendHeight);
    observer.observe(document.body, { childList: true, subtree: true });

    // Focus on first field
    document.addEventListener('DOMContentLoaded', function() {
        const firstInput = document.querySelector('input, textarea');
        if (firstInput) firstInput.focus();
    });
</script>
</body>
</html>