@extends('layouts.app')

@section('title', $title ?? 'Liste des Gyms')

@section('content')
    <div class="content">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h2>{{ $title ?? 'Gyms enregistrés' }}</h2>
            <a href="{{ route('admin.gyms.create') }}" class="btn-add">
                <i class="fas fa-plus"></i> Ajouter un Gym
            </a>
        </div>

        @if (session('success'))
            <script>
                Swal.fire({
                    icon: 'success',
                    title: 'Done!',
                    text: '{{ session('success') }}',
                    confirmButtonColor: '#D30402'
                });
            </script>
        @endif

        @if($gyms->count() > 0)
            <table>
                <thead>
                <tr>
                    @foreach(array_keys($gyms->first()->getAttributes()) as $column)
                        @if(!in_array($column, ['created_at', 'updated_at']))
                            <th>{{ ucfirst($column) }}</th>
                        @endif
                    @endforeach
                    <th>Actions</th>
                </tr>
                </thead>

                <tbody>
                @foreach($gyms as $gym)
                    <tr>

                        @foreach($gym->getAttributes() as $key => $value)
                            @if(!in_array($key, ['created_at', 'updated_at']))
                                {{-- Champ de statut --}}
                                @if($key === 'validate')
                                    <td>
                                        @if($value === 1)
                                            <span class="status-validated">Validé</span>
                                        @elseif($value === 0)
                                            <span class="status-refused">Refusé</span>
                                        @else
                                            <span class="status-pending">En attente</span>
                                        @endif
                                    </td>

                                    {{-- Champs images stockées en BLOB --}}
                                @elseif(in_array($key, ['photo1', 'photo2', 'photo3']))
                                    <td>
                                        @if($value)
                                            <img src="data:image/jpeg;base64,{{ base64_encode($value) }}"
                                                 alt="Image du gym"
                                                 width="80"
                                                 height="80"
                                                 style="object-fit: cover; border-radius: 8px; box-shadow: 0 0 4px rgba(0,0,0,0.2);">
                                        @else
                                            <span>Aucune image</span>
                                        @endif
                                    </td>

                                    {{-- Autres champs --}}
                                @else
                                    <td>{{ Str::limit($value, 50) }}</td>
                                @endif
                            @endif
                        @endforeach

                            {{-- Boutons d'action --}}
                            <td class="action-buttons">
                                <!-- Bouton Modifier -->
                                <a href="{{ route('admin.gyms.edit', $gym->id) }}" class="btn-edit" title="Modifier">
                                    <i class="fas fa-edit"></i> Modifier
                                </a>

                                <!-- Boutons Valider/Refuser -->
                                @if($gym->validate !== 1)
                                    <a href="{{ route('admin.gyms.validate', $gym->id) }}" class="btn-validate" data-id="{{ $gym->id }}">
                                        <i class="fas fa-check"></i> Valider
                                    </a>
                                @endif
                                @if($gym->validate !== 0)
                                    <a href="{{ route('admin.gyms.validate', $gym->id) }}" class="btn-refuse" data-id="{{ $gym->id }}">
                                        <i class="fas fa-times"></i> Refuser
                                    </a>
                                @endif

                                <!-- Bouton Supprimer -->
                                <a href="{{ route('admin.gyms.destroy', $gym->id) }}" class="btn-delete" onclick="return confirmDelete()" title="Supprimer">
                                    <i class="fas fa-trash"></i> Supprimer
                                </a>
                            </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        @else
            <div class="no-data">
                <p>Aucun gym trouvé.</p>
                <a href="{{ route('admin.gyms.create') }}" class="btn-add">
                    <i class="fas fa-plus"></i> Ajouter votre premier gym
                </a>
            </div>
        @endif
    </div>

    <style>
        .btn-add {
            background: #D30402;
            color: white;
            padding: 10px 20px;
            border-radius: 6px;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            font-weight: 500;
            transition: background 0.3s;
        }

        .btn-add:hover {
            background: #b90302;
            color: white;
        }

        .no-data {
            text-align: center;
            padding: 40px;
            background: #f9f9f9;
            border-radius: 8px;
        }

        .btn-delete {
            background: #dc3545;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            text-decoration: none;
            font-size: 12px;
        }

        .btn-delete:hover {
            background: #c82333;
            color: white;
        }
    </style>

    <script>
        function confirmDelete() {
            return confirm('Êtes-vous sûr de vouloir supprimer ce gym ? Cette action est irréversible.');
        }
    </script>
@endsection