<?php

namespace App\Http\Controllers;

use App\Models\RegisterMember;
use Illuminate\Http\Request;

class RegisterMemberController extends Controller
{
    public function liste(Request $request)
    {
        // Initialiser les variables
        $RegisterMembers = collect();
        $showResults = false;

        // Récupérer tous les rôles uniques pour le filtre
        $roles = RegisterMember::where('validate', true)
            ->distinct('role')
            ->pluck('role');

        // Vérifier si un filtre a été appliqué
        $hasFilter = $request->has('search') && !empty($request->search) ||
            $request->has('role') && $request->role != 'all';

        if ($hasFilter) {
            $showResults = true;

            // Commencer avec la requête de base
            $query = RegisterMember::where('validate', true);

            // Filtre par rôle
            if ($request->has('role') && $request->role != 'all') {
                $query->where('role', $request->role);
            }

            // Recherche par nom/prénom/email/matricule
            if ($request->has('search') && !empty($request->search)) {
                $searchTerm = $request->search;
                $query->where(function($q) use ($searchTerm) {
                    $q->where('nom', 'LIKE', "%{$searchTerm}%")
                        ->orWhere('prenom', 'LIKE', "%{$searchTerm}%")
                        ->orWhere('email', 'LIKE', "%{$searchTerm}%")
                        ->orWhere('matricule', 'LIKE', "%{$searchTerm}%")
                        ->orWhere('tel', 'LIKE', "%{$searchTerm}%");
                });
            }

            // Récupérer les membres avec pagination
            $RegisterMembers = $query->paginate(12)->appends($request->except('page'));
        }

        return view('pages.register_member.liste', [
            'RegisterMembers' => $RegisterMembers,
            'roles' => $roles,
            'showResults' => $showResults,
            'hasFilter' => $hasFilter
        ]);
    }
    public function store(Request $request)
    {
        if ($request->hasFile('photo1')) {
            $photoData = file_get_contents($request->file('photo1')->getRealPath());
        }

        // ✅ 5. Si certificat existe → on le stocke dans le dossier public
        if ($request->hasFile('certificat')) {
            $role = str_replace(' ', '_', strtolower($request->role ?? 'autre'));
            $path = $request->file('certificat')->storeAs(
                "register_members/{$role}",
                time() . '_certificat.' . $request->file('certificat')->getClientOriginalExtension(),
                'public'
            );
        }
        $countryCode = $this->getCountryCodeFromNationality($request->nationalite);
        RegisterMember::create([
            'photo1' => $photoData,
            'certificat' => $path,
            'nom' => $request->nom??'',
            'prenom'=> $request->prenom??'',
            'adresse' => $request->adresse??'',
            'tel' => $request->tel??'',
            'country_code' => $countryCode,
            'email' => $request->email??'',
            'nationalite' => $request->nationalite??'',
            'matricule' => $request->matricule??'',
            'degree' => $request->degree??'',
            'level' => $request->level??'',
            'role' => $request->role??'',
        ]);

        // ✅ 7. Retour succès
        return redirect()->back()->with('success', 'Registration successfully registered 🎉');
    }
    private function getCountryCodeFromNationality($nationality)
    {
        $countries = [
            'Afghanistan' => 'af',
            'Albania' => 'al',
            'Algeria' => 'dz',
            'Andorra' => 'ad',
            'Angola' => 'ao',
            'Antigua and Barbuda' => 'ag',
            'Argentina' => 'ar',
            'Armenia' => 'am',
            'Australia' => 'au',
            'Austria' => 'at',
            'Azerbaijan' => 'az',
            'Bahamas' => 'bs',
            'Bahrain' => 'bh',
            'Bangladesh' => 'bd',
            'Barbados' => 'bb',
            'Belarus' => 'by',
            'Belgium' => 'be',
            'Belize' => 'bz',
            'Benin' => 'bj',
            'Bhutan' => 'bt',
            'Bolivia' => 'bo',
            'Bosnia and Herzegovina' => 'ba',
            'Botswana' => 'bw',
            'Brazil' => 'br',
            'Brunei' => 'bn',
            'Bulgaria' => 'bg',
            'Burkina Faso' => 'bf',
            'Burundi' => 'bi',
            'Cabo Verde' => 'cv',
            'Cambodia' => 'kh',
            'Cameroon' => 'cm',
            'Canada' => 'ca',
            'Central African Republic' => 'cf',
            'Chad' => 'td',
            'Chile' => 'cl',
            'China' => 'cn',
            'Colombia' => 'co',
            'Comoros' => 'km',
            'Congo (Brazzaville)' => 'cg',
            'Congo (Kinshasa)' => 'cd',
            'Costa Rica' => 'cr',
            'Croatia' => 'hr',
            'Cuba' => 'cu',
            'Cyprus' => 'cy',
            'Czech Republic' => 'cz',
            'Denmark' => 'dk',
            'Djibouti' => 'dj',
            'Dominica' => 'dm',
            'Dominican Republic' => 'do',
            'Ecuador' => 'ec',
            'Egypt' => 'eg',
            'El Salvador' => 'sv',
            'Equatorial Guinea' => 'gq',
            'Eritrea' => 'er',
            'Estonia' => 'ee',
            'Eswatini' => 'sz',
            'Ethiopia' => 'et',
            'Fiji' => 'fj',
            'Finland' => 'fi',
            'France' => 'fr',
            'Gabon' => 'ga',
            'Gambia' => 'gm',
            'Georgia' => 'ge',
            'Germany' => 'de',
            'Ghana' => 'gh',
            'Greece' => 'gr',
            'Grenada' => 'gd',
            'Guatemala' => 'gt',
            'Guinea' => 'gn',
            'Guinea-Bissau' => 'gw',
            'Guyana' => 'gy',
            'Haiti' => 'ht',
            'Honduras' => 'hn',
            'Hungary' => 'hu',
            'Iceland' => 'is',
            'India' => 'in',
            'Indonesia' => 'id',
            'Iran' => 'ir',
            'Iraq' => 'iq',
            'Ireland' => 'ie',
            'Italy' => 'it',
            'Jamaica' => 'jm',
            'Japan' => 'jp',
            'Jordan' => 'jo',
            'Kazakhstan' => 'kz',
            'Kenya' => 'ke',
            'Kiribati' => 'ki',
            'Kuwait' => 'kw',
            'Kyrgyzstan' => 'kg',
            'Laos' => 'la',
            'Latvia' => 'lv',
            'Lebanon' => 'lb',
            'Lesotho' => 'ls',
            'Liberia' => 'lr',
            'Libya' => 'ly',
            'Liechtenstein' => 'li',
            'Lithuania' => 'lt',
            'Luxembourg' => 'lu',
            'Madagascar' => 'mg',
            'Malawi' => 'mw',
            'Malaysia' => 'my',
            'Maldives' => 'mv',
            'Mali' => 'ml',
            'Malta' => 'mt',
            'Marshall Islands' => 'mh',
            'Mauritania' => 'mr',
            'Mauritius' => 'mu',
            'Mexico' => 'mx',
            'Micronesia' => 'fm',
            'Moldova' => 'md',
            'Monaco' => 'mc',
            'Mongolia' => 'mn',
            'Montenegro' => 'me',
            'Morocco' => 'ma',
            'Mozambique' => 'mz',
            'Myanmar (Burma)' => 'mm',
            'Namibia' => 'na',
            'Nauru' => 'nr',
            'Nepal' => 'np',
            'Netherlands' => 'nl',
            'New Zealand' => 'nz',
            'Nicaragua' => 'ni',
            'Niger' => 'ne',
            'Nigeria' => 'ng',
            'North Korea' => 'kp',
            'North Macedonia' => 'mk',
            'Norway' => 'no',
            'Oman' => 'om',
            'Pakistan' => 'pk',
            'Palau' => 'pw',
            'Palestine' => 'ps',
            'Panama' => 'pa',
            'Papua New Guinea' => 'pg',
            'Paraguay' => 'py',
            'Peru' => 'pe',
            'Philippines' => 'ph',
            'Poland' => 'pl',
            'Portugal' => 'pt',
            'Qatar' => 'qa',
            'Romania' => 'ro',
            'Russia' => 'ru',
            'Rwanda' => 'rw',
            'Saint Kitts and Nevis' => 'kn',
            'Saint Lucia' => 'lc',
            'Saint Vincent and the Grenadines' => 'vc',
            'Samoa' => 'ws',
            'San Marino' => 'sm',
            'Sao Tome and Principe' => 'st',
            'Saudi Arabia' => 'sa',
            'Senegal' => 'sn',
            'Serbia' => 'rs',
            'Seychelles' => 'sc',
            'Sierra Leone' => 'sl',
            'Singapore' => 'sg',
            'Slovakia' => 'sk',
            'Slovenia' => 'si',
            'Solomon Islands' => 'sb',
            'Somalia' => 'so',
            'South Africa' => 'za',
            'South Korea' => 'kr',
            'South Sudan' => 'ss',
            'Spain' => 'es',
            'Sri Lanka' => 'lk',
            'Sudan' => 'sd',
            'Suriname' => 'sr',
            'Sweden' => 'se',
            'Switzerland' => 'ch',
            'Syria' => 'sy',
            'Taiwan' => 'tw',
            'Tajikistan' => 'tj',
            'Tanzania' => 'tz',
            'Thailand' => 'th',
            'Timor-Leste' => 'tl',
            'Togo' => 'tg',
            'Tonga' => 'to',
            'Trinidad and Tobago' => 'tt',
            'Tunisia' => 'tn',
            'Turkey' => 'tr',
            'Turkmenistan' => 'tm',
            'Tuvalu' => 'tv',
            'Uganda' => 'ug',
            'Ukraine' => 'ua',
            'United Arab Emirates' => 'ae',
            'United Kingdom' => 'gb',
            'United States' => 'us',
            'Uruguay' => 'uy',
            'Uzbekistan' => 'uz',
            'Vanuatu' => 'vu',
            'Vatican City' => 'va',
            'Venezuela' => 've',
            'Vietnam' => 'vn',
            'Yemen' => 'ye',
            'Zambia' => 'zm',
            'Zimbabwe' => 'zw',
        ];


        // Chercher par texte exact
        if (isset($countries[$nationality])) {
            return $countries[$nationality];
        }

        // Chercher si la nationalité contient un emoji drapeau (🇹🇳 Tunisia)
        preg_match('/^🇦-🇿 (.+)$/', $nationality, $matches);
        if (isset($matches[1]) && isset($countries[$matches[1]])) {
            return $countries[$matches[1]];
        }

        return null;
    }
    public function show($id,$nom)
    {
        $member = RegisterMember::findOrFail($id);
        return view('pages.register_member.detail', compact('member'));
    }

}
